Public Class PointDesc

    Private mPetName As String
    Private mCreationDate As DateTime

    Public Sub New(ByVal petName As String)
        mPetName = petName
        mCreationDate = DateTime.Now
    End Sub

    Public Property PetName() As String
        Get
            Return mPetName
        End Get
        Set(ByVal Value As String)
            mPetName = Value
        End Set
    End Property

    Public Function CreationDate() As String
        ' Ralentir les choses pendant une seconde...
        System.Threading.Thread.Sleep(1000)
        Return mCreationDate.ToLongTimeString()
    End Function
End Class

Public Class Point
    Implements ICloneable

    ' Donnes d'tat.
    Public x, y As Integer
    Public desc As PointDesc

    ' Constructeurs.
    Public Sub New()
    End Sub
    Public Sub New(ByVal xPos As Integer, ByVal yPos As Integer, _
                   ByVal name As String)
        x = xPos
        y = yPos
        desc = New PointDesc(name)
    End Sub

    ' La mthode unique de ICloneable.
    Public Function Clone() As Object _
        Implements ICloneable.Clone
        ' Ceci va recopier exactement la structure
        ' DateTime. Si vous dsirez un nouveau
        ' DateTime pour le clone, vous avez besoin du code
        ' ci-dessous.
        ' Return MemberwiseClone()

        Dim copyPt As Point = New Point(Me.x, Me.y, Me.desc.PetName)
        copyPt.desc = New PointDesc(Me.desc.PetName)
        Return copyPt
    End Function

    ' Surcharge de Object.ToString().
    Public Overrides Function ToString() As String
        Return "[Nom : " & desc.PetName & ", X : " & x & ", Y : " & y & _
       ", Date de cration : " & desc.CreationDate() & "]"
    End Function
End Class
